---
description: "How to access and use Pacing Agency documentation via MCP server"
alwaysApply: true
---

# Documentation Access

## MCP Server Configuration

This workspace has access to Pacing Agency's internal documentation via the Algolia MCP server (`pacing-docs`). The MCP server is configured in `.cursor/mcp.json`.

## How to Use Documentation

**Search for information:**
- Ask natural language questions: "How do I set up GTM tracking for a new client?"
- Find tool details: "Show me the Webflow CMS collections and structure"
- Get implementation guides: "What's the process for setting up server-side tracking?"
- Find prompts: "Show me the prompt for creating a new Webflow project"

**The AI will:**
1. Search the documentation index via Algolia MCP
2. Return relevant results with content snippets
3. Provide URLs to full documentation pages
4. For full content, ask to read specific tool pages directly

## What's Available

**Documentation includes:**
- **Tools**: Webflow, GTM, Shopify, Smootify, n8n, TwentyCRM, and 50+ other tools
- **Guides**: Server-side tracking, GTM setup, Webflow migrations, etc.
- **Architecture**: Complete tech stack overview, IDs, integrations
- **Prompts**: Ready-to-use prompts for common tasks
- **Workflows**: Automation patterns and n8n workflows

## Best Practices

**Before asking questions:**
- Search documentation first: "Search documentation for [topic]"
- Be specific: "How do I set up GTM for a Webflow site with server-side tracking?"
- Reference tools: "What are the Webflow CMS collection IDs?"

**When the AI searches:**
- Review the results and content snippets
- Ask follow-up questions if needed
- Request full content: "Show me the full Webflow tool documentation"

## File Organization

- **Tool docs**: `tools/<name>.md` - Auto-synced to documentation site
- **Custom pages**: `docs/<name>.md` - Standalone documentation
- **Never edit generated files** in `docusaurus/docs/tools/` (auto-generated)

## Before Creating New Files

Always ask: "Should I create a new file, or does existing documentation cover this?"

Search the documentation first to avoid duplicating information.
