---
description: "Language, tone, and writing style guidelines for Pacing Agency"
alwaysApply: true
---

# Style Guidelines

## Tone of Voice - "The Approachable Expert"

**Core Principles:**
- **Partnership-first**: Use "we" and "you" collaboratively. We're the client's marketing team, not just another agency.
- **Confident but approachable**: Expert-level confidence without arrogance. We know our stuff, but stay accessible.
- **Clear and action-oriented**: Direct calls to action, clear structure with headers and bullet points, outcome-focused.
- **Value-first**: Lead with business impact, not features. Explain outcomes, not just process.
- **Technical but accessible**: Use technical terms when appropriate, but explain them. Make complex concepts understandable.
- **Honest and transparent**: Acknowledge complexity when it exists. Set clear expectations.

## Language

- **British English spellings** throughout (realise, analyse, optimise, colour, etc.)
- **NO em dashes (—)** - use commas, periods, or parentheses instead
- **Active voice** and direct language
- **Short paragraphs** (2-3 sentences maximum)

## Writing Structure

- Problem → solution → result structure
- Use clear headings and bullet points for readability
- Include specific, measurable outcomes where possible
- Cross-reference related tools and workflows naturally

## Content Guidelines

- Lead with business impact/value, not features
- Show expertise confidently without arrogance
- Be outcome-focused, not feature-focused
- Use collaborative language ("we'll", "let's", "together")
